/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.gui.components.smith.ResultButton;
import com.tacz.guns.client.gui.components.smith.TypeButton;
import com.tacz.guns.client.resource.ClientAssetManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.init.ModCreativeTabs;
import com.tacz.guns.inventory.GunSmithTableMenu;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.packets.c2s.CraftC2SPacket;
import com.tacz.guns.util.RenderDistance;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_1059;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GunSmithTableScreen
extends class_465<GunSmithTableMenu> {
    private static final class_2960 TEXTURE = new class_2960("tacz", "textures/gui/gun_smith_table.png");
    private static final class_2960 SIDE = new class_2960("tacz", "textures/gui/gun_smith_table_side.png");
    private final List<String> recipeKeys = Lists.newArrayList();
    private final Map<String, List<class_2960>> recipes = Maps.newHashMap();
    private int typePage;
    private String selectedType;
    private List<class_2960> selectedRecipeList;
    private int indexPage;
    @Nullable
    private GunSmithTableRecipe selectedRecipe;
    @Nullable
    private Int2IntArrayMap playerIngredientCount;
    private int scale = 70;

    public GunSmithTableScreen(GunSmithTableMenu menu, class_1661 inventory, class_2561 title) {
        super((class_1703)menu, inventory, title);
        this.field_2792 = 344;
        this.field_2779 = 186;
        this.classifyRecipes();
        this.typePage = 0;
        this.selectedType = "ammo";
        this.selectedRecipeList = this.recipes.get(this.selectedType);
        this.indexPage = 0;
        this.selectedRecipe = this.getSelectedRecipe(this.selectedRecipeList.get(0));
        this.getPlayerIngredientCount(this.selectedRecipe);
    }

    public static void drawModCenteredString(class_332 gui, class_327 textRenderer, class_2561 component, int pX, int pY, int color) {
        class_5481 text = component.method_30937();
        gui.method_51430(textRenderer, text, pX - textRenderer.method_30880(text) / 2, pY, color, false);
    }

    private void classifyRecipes() {
        this.putRecipeType(ModCreativeTabs.AMMO_TAB);
        this.putRecipeType(ModCreativeTabs.ATTACHMENT_EXTENDED_MAG_TAB);
        this.putRecipeType(ModCreativeTabs.ATTACHMENT_SCOPE_TAB);
        this.putRecipeType(ModCreativeTabs.ATTACHMENT_MUZZLE_TAB);
        this.putRecipeType(ModCreativeTabs.ATTACHMENT_STOCK_TAB);
        this.putRecipeType(ModCreativeTabs.ATTACHMENT_GRIP_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_PISTOL_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_SNIPER_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_RIFLE_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_SHOTGUN_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_SMG_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_RPG_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_MG_TAB);
        TimelessAPI.getAllRecipes().forEach((id, recipe) -> {
            String groupName = recipe.getResult().group();
            if (this.recipeKeys.contains(groupName)) {
                this.recipes.computeIfAbsent(groupName, g -> Lists.newArrayList()).add(id);
            }
        });
    }

    private void putRecipeType(class_1761 tab) {
        class_2960 id = class_7923.field_44687.method_10221((Object)tab);
        String name = id.method_12832();
        this.recipeKeys.add(name);
    }

    @Nullable
    private GunSmithTableRecipe getSelectedRecipe(class_2960 recipeId) {
        return TimelessAPI.getAllRecipes().get(recipeId);
    }

    private void getPlayerIngredientCount(GunSmithTableRecipe recipe) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        List<GunSmithTableIngredient> ingredients = recipe.getInputs();
        int size = ingredients.size();
        this.playerIngredientCount = new Int2IntArrayMap(size);
        for (int i = 0; i < size; ++i) {
            GunSmithTableIngredient ingredient = ingredients.get(i);
            class_1661 inventory = player.method_31548();
            int count = 0;
            for (class_1799 stack : inventory.field_7547) {
                if (stack.method_7960() || !ingredient.ingredient().method_8093(stack)) continue;
                count += stack.method_7947();
            }
            this.playerIngredientCount.put(i, count);
        }
    }

    public void updateIngredientCount() {
        if (this.selectedRecipe != null) {
            this.getPlayerIngredientCount(this.selectedRecipe);
        }
        this.method_25426();
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37067();
        this.addTypePageButtons();
        this.addTypeButtons();
        this.addIndexPageButtons();
        this.addIndexButtons();
        this.addScaleButtons();
        this.addCraftButton();
        this.addUrlButton();
    }

    private void addCraftButton() {
        this.method_37063((class_364)new class_344(this.field_2776 + 289, this.field_2800 + 162, 48, 18, 138, 164, 18, TEXTURE, b -> {
            if (this.selectedRecipe != null && this.playerIngredientCount != null) {
                List<GunSmithTableIngredient> inputs = this.selectedRecipe.getInputs();
                int size = inputs.size();
                for (int i = 0; i < size; ++i) {
                    int needCount;
                    if (i >= this.playerIngredientCount.size()) {
                        return;
                    }
                    int hasCount = this.playerIngredientCount.get(i);
                    if (hasCount >= (needCount = inputs.get(i).count())) continue;
                    return;
                }
                NetworkHandler.sendToServer(new CraftC2SPacket(this.selectedRecipe.method_8114(), ((GunSmithTableMenu)this.field_2797).field_7763));
            }
        }));
    }

    private void addUrlButton() {
        this.method_37063((class_364)new class_344(this.field_2776 + 112, this.field_2800 + 164, 18, 18, 149, 211, 18, TEXTURE, b -> {
            if (this.selectedRecipe != null) {
                class_2960 id;
                class_1799 output = this.selectedRecipe.getOutput();
                class_1792 item = output.method_7909();
                if (item instanceof IGun) {
                    IGun iGun = (IGun)item;
                    id = iGun.getGunId(output);
                } else if (item instanceof IAttachment) {
                    IAttachment iAttachment = (IAttachment)item;
                    id = iAttachment.getAttachmentId(output);
                } else if (item instanceof IAmmo) {
                    IAmmo iAmmo = (IAmmo)item;
                    id = iAmmo.getAmmoId(output);
                } else {
                    return;
                }
                PackInfo packInfo = ClientAssetManager.INSTANCE.getPackInfo(id);
                if (packInfo == null) {
                    return;
                }
                String url = packInfo.getUrl();
                if (StringUtils.isNotBlank((CharSequence)url) && this.field_22787 != null) {
                    this.field_22787.method_1507((class_437)new class_407(yes -> {
                        if (yes) {
                            class_156.method_668().method_670(url);
                        }
                        this.field_22787.method_1507((class_437)this);
                    }, url, false));
                }
            }
        }));
    }

    private void addIndexButtons() {
        int finalIndex;
        if (this.selectedRecipeList == null || this.selectedRecipeList.isEmpty()) {
            return;
        }
        for (int i = 0; i < 6 && (finalIndex = i + this.indexPage * 6) < this.selectedRecipeList.size(); ++i) {
            int yOffset = this.field_2800 + 66 + 17 * i;
            TimelessAPI.getRecipe(this.selectedRecipeList.get(finalIndex)).ifPresent(recipe -> {
                ResultButton button = (ResultButton)this.method_37063((class_364)new ResultButton(this.field_2776 + 144, yOffset, recipe.getOutput(), b -> {
                    this.selectedRecipe = recipe;
                    this.getPlayerIngredientCount(this.selectedRecipe);
                    this.method_25426();
                }));
                if (this.selectedRecipe != null && recipe.method_8114().equals((Object)this.selectedRecipe.method_8114())) {
                    button.setSelected(true);
                }
            });
        }
    }

    private void addTypeButtons() {
        for (int i = 0; i < 7; ++i) {
            int typeIndex = this.typePage * 7 + i;
            if (typeIndex >= this.recipes.size()) {
                return;
            }
            String type = this.recipeKeys.get(typeIndex);
            int xOffset = this.field_2776 + 157 + 24 * i;
            List<class_2960> recipeIdGroups = this.recipes.get(type);
            if (recipeIdGroups.isEmpty()) continue;
            class_1799 icon = class_1799.field_8037;
            class_2960 tabId = new class_2960("tacz", type);
            class_1761 modTab = (class_1761)class_7923.field_44687.method_10223(tabId);
            if (modTab != null) {
                icon = modTab.method_7747();
            }
            TypeButton typeButton = this.getTypeButton(xOffset, icon, type);
            this.method_37063((class_364)typeButton);
        }
    }

    @NotNull
    private TypeButton getTypeButton(int xOffset, class_1799 icon, String type) {
        TypeButton typeButton = new TypeButton(xOffset, this.field_2800 + 2, icon, b -> {
            this.selectedType = type;
            this.selectedRecipeList = this.recipes.get(type);
            this.indexPage = 0;
            this.selectedRecipe = this.getSelectedRecipe(this.selectedRecipeList.get(0));
            this.getPlayerIngredientCount(this.selectedRecipe);
            this.method_25426();
        });
        if (this.selectedType.equals(type)) {
            typeButton.setSelected(true);
        }
        return typeButton;
    }

    private void addIndexPageButtons() {
        this.method_37063((class_364)new class_344(this.field_2776 + 143, this.field_2800 + 56, 96, 6, 40, 166, 6, TEXTURE, b -> {
            if (this.indexPage > 0) {
                --this.indexPage;
                this.method_25426();
            }
        }));
        this.method_37063((class_364)new class_344(this.field_2776 + 143, this.field_2800 + 171, 96, 6, 40, 186, 6, TEXTURE, b -> {
            int maxIndexPage;
            if (this.selectedRecipeList != null && !this.selectedRecipeList.isEmpty() && this.indexPage < (maxIndexPage = (this.selectedRecipeList.size() - 1) / 6)) {
                ++this.indexPage;
                this.method_25426();
            }
        }));
    }

    private void addTypePageButtons() {
        this.method_37063((class_364)new class_344(this.field_2776 + 136, this.field_2800 + 4, 18, 20, 0, 162, 20, TEXTURE, b -> {
            if (this.typePage > 0) {
                --this.typePage;
                this.method_25426();
            }
        }));
        this.method_37063((class_364)new class_344(this.field_2776 + 327, this.field_2800 + 4, 18, 20, 20, 162, 20, TEXTURE, b -> {
            int maxIndexPage = (this.recipes.size() - 1) / 7;
            if (this.typePage < maxIndexPage) {
                ++this.typePage;
                this.method_25426();
            }
        }));
    }

    private void addScaleButtons() {
        this.method_37063((class_364)new class_344(this.field_2776 + 5, this.field_2800 + 5, 10, 10, 188, 173, 10, TEXTURE, b -> {
            this.scale = Math.min(this.scale + 20, 200);
        }));
        this.method_37063((class_364)new class_344(this.field_2776 + 17, this.field_2800 + 5, 10, 10, 200, 173, 10, TEXTURE, b -> {
            this.scale = Math.max(this.scale - 20, 10);
        }));
        this.method_37063((class_364)new class_344(this.field_2776 + 29, this.field_2800 + 5, 10, 10, 212, 173, 10, TEXTURE, b -> {
            this.scale = 70;
        }));
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        GunSmithTableScreen.drawModCenteredString(graphics, this.field_22793, (class_2561)class_2561.method_43471((String)"gui.tacz.gun_smith_table.preview"), this.field_2776 + 108, this.field_2800 + 5, 0x555555);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)String.format("tacz.type.%s.name", this.selectedType)), this.field_2776 + 150, this.field_2800 + 32, 0x555555, false);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.tacz.gun_smith_table.ingredient"), this.field_2776 + 254, this.field_2800 + 50, 0x555555, false);
        GunSmithTableScreen.drawModCenteredString(graphics, this.field_22793, (class_2561)class_2561.method_43471((String)"gui.tacz.gun_smith_table.craft"), this.field_2776 + 312, this.field_2800 + 167, 0xFFFFFF);
        if (this.selectedRecipe != null) {
            this.renderLeftModel(this.selectedRecipe);
            this.renderPackInfo(graphics, this.selectedRecipe);
        }
        if (this.selectedRecipeList != null && !this.selectedRecipeList.isEmpty()) {
            this.renderIngredient(graphics, mouseX, mouseY);
        }
        this.field_33816.stream().filter(w -> w instanceof ResultButton).forEach(w -> ((ResultButton)((Object)w)).renderTooltips(stack -> graphics.method_51446(this.field_22793, stack, mouseX, mouseY)));
    }

    private void renderPackInfo(class_332 gui, GunSmithTableRecipe recipe) {
        class_2960 id;
        class_1799 output = recipe.getOutput();
        class_1792 item = output.method_7909();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            id = iGun.getGunId(output);
        } else if (item instanceof IAttachment) {
            IAttachment iAttachment = (IAttachment)item;
            id = iAttachment.getAttachmentId(output);
        } else if (item instanceof IAmmo) {
            IAmmo iAmmo = (IAmmo)item;
            id = iAmmo.getAmmoId(output);
        } else {
            return;
        }
        PackInfo packInfo = ClientAssetManager.INSTANCE.getPackInfo(id);
        class_4587 poseStack = gui.method_51448();
        if (packInfo != null) {
            poseStack.method_22903();
            poseStack.method_22905(0.75f, 0.75f, 1.0f);
            class_5250 nameText = class_2561.method_43471((String)packInfo.getName());
            gui.method_51439(this.field_22793, (class_2561)nameText, (int)((float)(this.field_2776 + 6) / 0.75f), (int)((float)(this.field_2800 + 122) / 0.75f), class_124.field_1063.method_532().intValue(), false);
            poseStack.method_22909();
            poseStack.method_22903();
            poseStack.method_22905(0.5f, 0.5f, 1.0f);
            int offsetX = (this.field_2776 + 6) * 2;
            int offsetY = (this.field_2800 + 123) * 2;
            int nameWidth = this.field_22793.method_27525((class_5348)nameText);
            class_5250 ver = class_2561.method_43470((String)("v" + packInfo.getVersion())).method_27692(class_124.field_1073);
            gui.method_51439(this.field_22793, (class_2561)ver, (int)((float)offsetX + (float)nameWidth * 0.75f / 0.5f + 5.0f), offsetY, class_124.field_1063.method_532().intValue(), false);
            offsetY += 14;
            String descKey = packInfo.getDescription();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{descKey})) {
                class_5250 desc = class_2561.method_43471((String)descKey);
                List split = this.field_22793.method_1728((class_5348)desc, 245);
                for (class_5481 charSequence : split) {
                    gui.method_51430(this.field_22793, charSequence, offsetX, offsetY, class_124.field_1063.method_532().intValue(), false);
                    Objects.requireNonNull(this.field_22793);
                    offsetY += 9;
                }
                offsetY += 3;
            }
            gui.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.tacz.gun_smith_table.license").method_10852((class_2561)class_2561.method_43470((String)packInfo.getLicense()).method_27692(class_124.field_1063)), offsetX, offsetY, class_124.field_1063.method_532().intValue(), false);
            offsetY += 12;
            List<String> authors = packInfo.getAuthors();
            if (!authors.isEmpty()) {
                gui.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.tacz.gun_smith_table.authors").method_10852((class_2561)class_2561.method_43470((String)StringUtils.join(authors, (String)", ")).method_27692(class_124.field_1063)), offsetX, offsetY, class_124.field_1063.method_532().intValue(), false);
                offsetY += 12;
            }
            gui.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.tacz.gun_smith_table.date").method_10852((class_2561)class_2561.method_43470((String)packInfo.getDate()).method_27692(class_124.field_1063)), offsetX, offsetY, class_124.field_1063.method_532().intValue(), false);
            poseStack.method_22909();
        } else {
            class_2960 recipeId = recipe.method_8114();
            gui.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.tacz.gun_smith_table.error").method_27692(class_124.field_1079), this.field_2776 + 6, this.field_2800 + 122, 0xAF0000, false);
            gui.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"gui.tacz.gun_smith_table.error.id", (Object[])new Object[]{recipeId.toString()}).method_27692(class_124.field_1079), this.field_2776 + 6, this.field_2800 + 134, 0xFFFFFF, false);
            PackInfo errorPackInfo = ClientAssetManager.INSTANCE.getPackInfo(recipeId);
            if (errorPackInfo != null) {
                gui.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)errorPackInfo.getName()).method_27692(class_124.field_1079), this.field_2776 + 6, this.field_2800 + 146, 0xAF0000, false);
            }
        }
    }

    private void renderIngredient(class_332 gui, int mouseX, int mouseY) {
        if (this.selectedRecipe == null) {
            return;
        }
        List<GunSmithTableIngredient> inputs = this.selectedRecipe.getInputs();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 2; ++j) {
                boolean hovered;
                int index = i * 2 + j;
                if (index >= inputs.size()) {
                    return;
                }
                int offsetX = this.field_2776 + 254 + 45 * j;
                int offsetY = this.field_2800 + 62 + 17 * i;
                GunSmithTableIngredient smithTableIngredient = inputs.get(index);
                class_1856 ingredient = smithTableIngredient.ingredient();
                class_1799[] items = ingredient.method_8105();
                class_1799 item = class_1799.field_8037;
                if (items.length > 0) {
                    int itemIndex = (int)(System.currentTimeMillis() / 1000L) % items.length;
                    item = items[itemIndex];
                }
                gui.method_51445(item, offsetX, offsetY);
                class_4587 poseStack = gui.method_51448();
                poseStack.method_22903();
                poseStack.method_46416(0.0f, 0.0f, 200.0f);
                poseStack.method_22905(0.5f, 0.5f, 1.0f);
                int count = smithTableIngredient.count();
                int hasCount = 0;
                if (this.playerIngredientCount != null && index < this.playerIngredientCount.size()) {
                    hasCount = this.playerIngredientCount.get(index);
                }
                int color = count <= hasCount ? 0xFFFFFF : 0xFF0000;
                gui.method_51433(this.field_22793, String.format("%d/%d", count, hasCount), (offsetX + 17) * 2, (offsetY + 10) * 2, color, false);
                poseStack.method_22909();
                boolean bl = hovered = mouseX >= offsetX && mouseY >= offsetY && (float)mouseX < (float)offsetX + 16.0f && (float)mouseY < (float)offsetY + 16.0f;
                if (!hovered) continue;
                gui.method_51446(this.field_22793, item, mouseX, mouseY);
            }
        }
    }

    private void renderLeftModel(GunSmithTableRecipe recipe) {
        RenderDistance.markGuiRenderTimestamp();
        float rotationPeriod = 8.0f;
        int xPos = this.field_2776 + 60;
        int yPos = this.field_2800 + 50;
        int startX = this.field_2776 + 3;
        int startY = this.field_2800 + 16;
        int width = 128;
        int height = 99;
        float rotPitch = 15.0f;
        class_1041 window = class_310.method_1551().method_22683();
        double windowGuiScale = window.method_4495();
        int scissorX = (int)((double)startX * windowGuiScale);
        int scissorY = (int)((double)window.method_4507() - (double)(startY + height) * windowGuiScale);
        int scissorW = (int)((double)width * windowGuiScale);
        int scissorH = (int)((double)height * windowGuiScale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
        class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_1059.field_5275);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4587 posestack = RenderSystem.getModelViewStack();
        posestack.method_22903();
        posestack.method_46416((float)xPos, (float)yPos, 200.0f);
        posestack.method_22904(8.0, 8.0, 0.0);
        posestack.method_22905(1.0f, -1.0f, 1.0f);
        posestack.method_22905((float)this.scale, (float)this.scale, (float)this.scale);
        float rot = (float)(System.currentTimeMillis() % (long)((int)(rotationPeriod * 1000.0f))) * (360.0f / (rotationPeriod * 1000.0f));
        posestack.method_22907(class_7833.field_40714.rotationDegrees(rotPitch));
        posestack.method_22907(class_7833.field_40716.rotationDegrees(rot));
        RenderSystem.applyModelViewMatrix();
        class_4587 tmpPose = new class_4587();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_308.method_24210();
        class_310.method_1551().method_1480().method_23178(recipe.getOutput(), class_811.field_4319, 0xF000F0, class_4608.field_21444, tmpPose, (class_4597)bufferSource, null, 0);
        bufferSource.method_22993();
        RenderSystem.enableDepthTest();
        class_308.method_24211();
        posestack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableScissor();
    }

    protected void method_2388(@NotNull class_332 gui, int mouseX, int mouseY) {
    }

    protected void method_2389(@NotNull class_332 gui, float partialTick, int mouseX, int mouseY) {
        this.method_25420(gui);
        gui.method_25302(SIDE, this.field_2776, this.field_2800, 0, 0, 134, 187);
        gui.method_25302(TEXTURE, this.field_2776 + 136, this.field_2800 + 27, 0, 0, 208, 160);
    }

    public boolean method_25421() {
        return false;
    }
}

